/****** Object:  StoredProcedure [dbo].[P_PG_FORN_PG_CRED_SALDO_ABERTO_PROC]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_PG_FORN_PG_CRED_SALDO_ABERTO_PROC]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_PG_FORN_PG_CRED_SALDO_ABERTO_PROC]
GO
--exec P_PG_FORN_PG_CRED_SALDO_ABERTO_PROC '2016-07-01'
CREATE PROCEDURE P_PG_FORN_PG_CRED_SALDO_ABERTO_PROC @DT_PROC DATETIME
AS	
/*
	Para o correto funcionamento deste processo o job de controel de historico do contas a pagar
	deve esta configurado para que o sistema possa trabalhar de forma correta com o saldo do contas a pagar
	
*/
	SET NOCOUNT ON	
	DECLARE @DIA DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DT_ATUAL DATETIME

	SET @DT_ATUAL=GETDATE()
	SET @DT_FIM= CONVERT(CHAR(10),@DT_ATUAL,112)
	PRINT 'Processando fechamento saldo fornecedor'
	SET @DIA = @DT_PROC
	WHILE @DT_FIM >= @DIA
	BEGIN
		PRINT 'Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
		--Gerando movimento em aberto por fornecedor
		DELETE FROM PG_FORN_PG_CRED_SALDO_ABERTO WHERE DT_MOV=@DIA
		INSERT INTO PG_FORN_PG_CRED_SALDO_ABERTO
		(
		DT_MOV,
		CD_EMP,
		CD_FORN,
		VLR_EM_ABERTO,
		DT_PROC,
		CD_BANDEIRA,
		TP_TRANSACAO)
		SELECT
			@DIA,
			PG_CRED_HISTORICO_CPL.CD_EMP,
			PG_CRED_HISTORICO_CPL.CD_FORN,
			ISNULL(SUM(PG_CRED_HISTORICO_CPL.SLD_DP),0),
			@DIA,
			PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA,
			0 --Contas a pagar 
		FROM
			PG_CRED_HISTORICO_CPL INNER JOIN PG_CRED_HISTORICO ON
			PG_CRED_HISTORICO_CPL.CD_CTR = PG_CRED_HISTORICO.CD_CTR
			INNER JOIN PRC_BANDEIRA_PRC_FILIAL ON
			PG_CRED_HISTORICO_CPL.CD_EMP =PRC_BANDEIRA_PRC_FILIAL.CD_EMP AND
			PG_CRED_HISTORICO_CPL.CD_FILIAL = PRC_BANDEIRA_PRC_FILIAL.CD_FILIAL 
		WHERE
			PG_CRED_HISTORICO.DT_PROC=@DIA
		GROUP BY
			PG_CRED_HISTORICO_CPL.CD_EMP,
			PG_CRED_HISTORICO_CPL.CD_FORN,
			PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA
		SELECT @DIA = @DIA + 1
	END		
PRINT 'Concluido.'